



<html>
<head>
  <title>javabog.dk - Webprogrammering med Java Server Pages - JSTL - JSP Standard Tag Library</title>
  <link rev="stylesheet" type="text/css" href="../typografi.css">
  <meta name="description" content="Lrebog i Java. Af Jacob Nordfalk. Udkommet hos Forlaget Globe">
  <meta name="keywords" content="designmnster, programmering, OOP, objekter, klasser, objektorienteret programmering, Java, JSP, lrebog, UML, IT">
</head>
<body bgcolor="#ffffff">



<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel5.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel7.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_JSP.html'>om bogen</a>

<H1 CLASS="western" STYLE="">6 <a name='afsn6'></a>JSTL - JSP
Standard Tag Library</H1>
<DIV ID="Indholdsfortegnelse7">
  <P STYLE="margin-top: 0.5cm; margin-bottom: 0cm"><BR>
  </P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>6.1
  Kernefunktionalitet (&lt;c: &gt;)  117</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">6.1.1
  Regneudtryk med EL - Expression Language  118</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">6.1.2
  Variabler  118</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">6.1.3
  Virkefelter  119</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">6.1.4
  Sikkerhed og behandling af formularer  119</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">6.1.5
  L&oslash;kker  120</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">6.1.6
  Oversigt  121</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>6.2
  Internationalisering og formatering (&lt;fmt: &gt;)  122</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">6.2.1
  Oversigt  122</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">6.2.2
  Eksempel p&aring; brug  123</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>6.3
  JSTL og databaser (&lt;sql: &gt;)  124</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">6.3.1
  Oversigt  125</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>6.4
  XML-behandling  (&lt;x: &gt;)  125</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">6.4.1
  Syndikering med XML-funktionerne i JSTL  125</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">6.4.2
  Caching af nyhedskilder  127</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">6.4.3
  WebRowSet og XML-transformering med JSTL  127</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">6.4.4
  Oversigt  129</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>6.5
  Forskellige funktioner (&lt;fn: &gt;)  129</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">6.5.1
  Oversigt  130</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>6.6
  Installation af JSTL og EL  130</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">6.6.1
  Versionsproblemer med JSTL og EL  131</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>6.7
  JSTL versus almindelig javakode i JSP  132</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>6.8
  Kommunikation mellem JSTL og Java  132</B></FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">6.8.1
  Javab&oslash;nner  133</FONT></FONT></P>
  <P STYLE="margin-left: 0.6cm; margin-top: 0.08cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 9pt">6.8.2
  Implicit definerede objekter i EL  133</FONT></FONT></P>
  <P STYLE="margin-left: 0.3cm; margin-top: 0.15cm; margin-bottom: 0cm">
  <FONT FACE="Helvetica, sans-serif"><FONT SIZE=2 STYLE="font-size: 11pt"><B>6.9
  Mere l&aelig;sning  133</B></FONT></FONT></P>
</DIV>

<P CLASS="kapiteloversigt-western" STYLE="font-weight: medium; text-decoration: none">
Dette kapitel er frivillig l&aelig;sning; det foruds&aelig;ttes ikke
i resten af bogen. 
</P>
<P CLASS="kapiteloversigt-western"><SPAN STYLE="font-weight: medium"><SPAN STYLE="text-decoration: none"><SPAN LANG="da-DK">Det
foruds&aelig;tter <a href='kapitel4.jsp'>kapitel 4</a>, Videre med JSP, men inddrager eksempler
fra mange kapitler b&aring;de f&oslash;r og efter dette kapitel. Det
anbefales derfor at du springer let hen over det du ikke forst&aring;r
og vender tilbage </SPAN></SPAN></SPAN>senere.</P>
<P CLASS="western" STYLE="">Med JSP 2.0, der
<SPAN LANG="da-DK">udkom</SPAN> primo 2004, blev det for alvor
muligt, at programmere JSP-sider i programmeringssproget JSTL (JSP
Standard Tag Library) og bruge regneudtryk i disse sider (EL -
Expression Language).</P>
<P CLASS="western">JSTL er et HTML-lignende sprog, som man kan skrive
koden, der udf&oslash;res p&aring; serveren i, i stedet for Java. For
ikke-Java-kyndige HTML-designere skulle JSTL v&aelig;re betydeligt
simplere at bruge end Java, da syntaksen ligner den, de i forvejen
kender fra HTML<A CLASS="sdfootnoteanc" NAME="sdfootnote1anc" HREF="#sdfootnote1sym"><SUP>1</SUP></A>.</P>
<P CLASS="western">Selvom denne bogs 'hovedsprog' er Java og ikke
JSTL, kan du v&aelig;lge at l&aelig;re JSTL. Dette kan du g&oslash;re
ved at l&aelig;se de andre kapitler og i stedet for at udf&oslash;re
Java-eksemplerne, kigge p&aring; og lege med JSTL-eksemplerne i dette
kapitel.</P>
<P CLASS="western">Et tag library (forkortet taglib) er, som navnet
siger, et bibliotek af HTML-lignende koder. Ligesom JSP-koderne
udf&oslash;res taglib-koderne p&aring; serveren.</P>

<H2 CLASS="western">6.1 <a name='afsn6.1'></a>Kernefunktionalitet (&lt;c: &gt;)</SPAN></H2>
<P CLASS="western">Kernefunktioner (de mest basale funktioner) i JSTL
ligger i core-taglibbet under navnet 'c'. Her er underst&oslash;ttelse
for variabler, betingelser, URL-styring og andre ting. 
</P>
<P CLASS="western">Her er eksemplet Alder fra <a href='kapitel2.jsp#afsn2.2'>afsnit 2.2</a> skrevet i
JSTL-syntaks:</P>
<PRE CLASS="kode-western">&lt;!-- <B>&lt;%@ taglib uri=&quot;http://java.sun.com/jsp/jstl/core&quot; prefix=&quot;c&quot;%&gt;</B> --&gt;
&lt;html&gt;
&lt;head&gt;&lt;title&gt;Alder med JSTL&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;
&lt;p&gt;
<B>&lt;c:set var=&quot;alder&quot; value=&quot;31&quot; /&gt;</B>
S&oslash;ren er <B>${alder}</B> &aring;r gammel.
Det svarer til <B>${12*alder}</B> m&aring;neder.&lt;br&gt;

<B>&lt;c:set var=&quot;alder&quot; value=&quot;3&quot; /&gt;</B>
Julie er <B>${alder}</B> &aring;r gammel. 

<B>&lt;c:set var=&quot;alder&quot; value=&quot;${alder*365}&quot; /&gt;</B>
Det svarer cirka til <B>${12*alder}</B> dage.&lt;br&gt;
&lt;/p&gt;
&lt;/body&gt;
&lt;/html&gt;</PRE>
<P CLASS="western" ALIGN=CENTER STYLE="margin-top: 0cm; margin-bottom: 0cm">
<IMG SRC="bog7_html_7e942770.png" NAME="Grafik29" ALIGN=BOTTOM BORDER=0></P>

<P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">Vi
starter med at importere core-taglibbet:</P>
<PRE CLASS="kode-western">&lt;%@ taglib uri=&quot;http://java.sun.com/jsp/jstl/core&quot; prefix=&quot;c&quot; %&gt;</PRE><P CLASS="western">
I eksemplet ovenfor har vi sat det ind i en HTML-kommentar &lt;!--
--&gt;. Det er strengt taget ikke n&oslash;dvendigt, men s&oslash;rger
for, at de fleste HTML-redigeringsv&aelig;rkt&oslash;jer (som f.eks.
Netscape/Mozilla Composer) lader koden st&aring; ur&oslash;rt, selvom
de ikke st&aring;r i JSP-kode. Almindelig javakode mellem &lt;% og %&gt;
g&aring;r ellers ofte g&aring;r tabt. 
</P>
<P CLASS="western">Nu kan vi bruge core-biblioteket under <SPAN LANG="da-DK">pr&aelig;fikset</SPAN>
&quot;c&quot; i JSP-siden, f.eks. til at s&aelig;tte en variabel til
en v&aelig;rdi:</P>
<PRE CLASS="kode-western">&lt;c:set var=&quot;alder&quot; value=&quot;31&quot; /&gt;</PRE><P CLASS="western">
I mods&aelig;tning til Java beh&oslash;ver man ikke definere typen af
en variabel, f&oslash;r man bruger den. 
</P>
<H3 CLASS="western">6.1.1 <a name='afsn6.1.1'></a>Regneudtryk med EL - Expression Language</H3>
<P CLASS="western">V&aelig;rdier fra variabler og regneudtryk skal i
JSTL puttes ind i et ${}-udtryk, som er en m&aring;de at g&oslash;re
brug af EL - Expression Language. Med JSP 2.0 kan evaluering af
${}-udtryk ske uden for JSTL, s&aring;dan at de bliver evalueret, n&aring;r
de st&aring;r direkte i HTML-koden:</P>
<PRE CLASS="kode-western">Det svarer til ${12*alder} m&aring;neder.&lt;br&gt;</PRE>
<P CLASS="western">I tidligere udgaver kunne EL-udtryk kun st&aring;
inde i JSTL-koder, s&aring; man m&aring;tte skrive dem ind i f.eks.
en &lt;c:out /&gt;:</P>
<PRE CLASS="kode-western">Det svarer til &lt;c:out value=&quot;${12*alder}&quot; /&gt; m&aring;neder.&lt;br&gt;</PRE><P CLASS="western">
<SPAN LANG="da-DK">Der kan stadig nogle enkelte steder v&aelig;re
grund til at bruge &lt;c:out /&gt;, nemlig hvis man &oslash;nsker at
undg&aring;, at v&aelig;rdien kan fortolkes som HTML-kode (se <a href='kapitel8.jsp#afsn8.5.1'>afsnit
8.5.1</a>, HTML-injektion og <a href='kapitel6.jsp#afsn6.1.4'>afsnit 6.1.4</a>, Sikkerhed og behandling af formularer).</SPAN></P>

<P CLASS="western"><SPAN LANG="da-DK">EL er et elegant sprog, der g&oslash;r
det muligt, at skrive ret lange Java-udtryk p&aring; kort form</SPAN>.
</P>
<P CLASS="western">S&aring;ledes kan knudrede Java-udtryk, som
f.eks.:</P>
<PRE CLASS="kode-western">Velkommen &lt;%= ((Bruger)session.getAttribute(&quot;bruger&quot;)).getNavn() %&gt; !</PRE><P CLASS="western">
med EL skrives som blot:</P>
<PRE CLASS="kode-western">Velkommen ${session.bruger.navn} !</PRE><P CLASS="western">
<SPAN LANG="da-DK">Det skyldes, at EL har en meget fleksibel
punktum-notation, der</SPAN> automatisk unders&oslash;ger egenskaber
p&aring; javab&oslash;nner og gennems&oslash;ger attributter p&aring;
implicitte objekter og andre n&oslash;gleindekserede objekter
(hashtabeller).</P>

<H3 CLASS="western">6.1.2 <a name='afsn6.1.2'></a>Variabler</H3>
<P CLASS="western">Variabler kan s&aelig;ttes med:</P>
<PRE CLASS="kode-western">&lt;c:set var=&quot;fornavn&quot; value=&quot;Jacob&quot;/&gt;</PRE><P CLASS="western">
der s&aelig;tter variablen 'fornavn' til &quot;Jacob&quot;. Findes
variablen ikke, oprettes den.</P>
<P CLASS="western">En anden mulighed er, at s&aelig;tte v&aelig;rdien
ind i :</P>
<PRE CLASS="kode-western">&lt;c:set var=&quot;fornavn&quot;&gt;
<SPAN LANG="da-DK">  Jacob</SPAN>
<SPAN LANG="da-DK">&lt;/c:set&gt;</SPAN></PRE>

<H3 CLASS="western">6.1.3 <a name='afsn6.1.3'></a>Virkefelter</H3>
<P CLASS="western">Som udgangspunkt har variabler kun siden som
virkefelt (scope=&quot;page&quot;), s&aring; de smides v&aelig;k, n&aring;r
foresp&oslash;rgslen er f&aelig;rdigbehandlet. Man kan specificere et
andet virkefelt med f.eks.:</P>
<PRE CLASS="kode-western">&lt;c:set var=&quot;fornavn&quot; value=&quot;Jacob&quot; scope=&quot;session&quot;/&gt;</PRE><P CLASS="western">
hvorefter variablen vil blive husket, s&aring; l&aelig;nge brugerens
session eksisterer.</P>
<P CLASS="western"><SPAN LANG="da-DK">De mulige virkefelter er: page,
request, session og application.</SPAN> Et (realistisk) eksempel p&aring;
brug af virkefelter kan ses i slutningen af <a href='kapitel6.jsp#afsn6.4.2'>afsnit 6.4.2</a>. 
</P>

<P CLASS="western">Vil man fjerne en variabel, kan det g&oslash;res
med f.eks.:</P>
<PRE CLASS="kode-western">&lt;c:remove var=&quot;navn&quot; scope=&quot;session&quot;/&gt;</PRE>
<H3 CLASS="western">6.1.4 <a name='afsn6.1.4'></a>Sikkerhed og behandling af formularer</H3>
<P CLASS="western">JSTL har med EL nogle ganske kraftige mekanismer
til at arbejde med formulardata.</P>
<P CLASS="western">Her eksemplet fra <a href='kapitel3.jsp#afsn3.2.5'>afsnit 3.2.5</a> (der udskriver alle
parametrene, der er overf&oslash;rt fra formularen i <a href='kapitel3.jsp#afsn3.2.4'>afsnit 3.2.4</a>),
skrevet i JSTL:</P>
<PRE CLASS="kode-western">&lt;!-- &lt;%@ <SPAN LANG="da-DK">taglib</SPAN> <SPAN LANG="da-DK">uri</SPAN>=&quot;http://<SPAN LANG="da-DK">java.sun.com/jsp/jstl</SPAN>/<SPAN LANG="da-DK">core</SPAN>&quot; <SPAN LANG="da-DK">prefix</SPAN>=&quot;c&quot;%&gt; --&gt;
&lt;html&gt;
&lt;head&gt;&lt;title&gt;Parametre3 med JSTL&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;

&lt;p&gt;
Her er parameteren &quot;navn&quot;: <SPAN LANG="da-DK">&lt;c:out value=&quot;</SPAN>${<SPAN LANG="da-DK">param</SPAN>['navn']}&quot;<SPAN LANG="da-DK">/&gt;</SPAN>&lt;br&gt;
Parameteren p&aring; en anden m&aring;de: <SPAN LANG="da-DK">&lt;c:out value=&quot;${param.navn}</SPAN>&quot;<SPAN LANG="da-DK">/&gt;</SPAN>&lt;br&gt;
&lt;/p&gt;

&lt;p&gt;
Andre parametre:&lt;br&gt;
&lt;c:<SPAN LANG="da-DK">forEach</SPAN> var=&quot;parametren&quot; <SPAN LANG="da-DK">items</SPAN>=&quot;${param}&quot;&gt;
  <SPAN LANG="da-DK">&lt;c:out value=&quot;${parametren.key}&quot;/&gt;</SPAN>
<SPAN LANG="da-DK">  med v&aelig;rdi: '&lt;c:out value=&quot;${parametren.value}&quot;/&gt;'.</SPAN>
 &lt;br&gt;
&lt;/c:forEach&gt;
&lt;/p&gt;

&lt;p&gt;
Parameteren 'kan_spise' har flere v&aelig;rdier.&lt;br&gt;
De er:
&lt;c:forEach var=&quot;vaerdi&quot; items=&quot;${<SPAN LANG="da-DK">paramValues</SPAN>['kan_spise']}&quot;&gt;
  <SPAN LANG="da-DK">&lt;c:out value=&quot;${vaerdi}&quot;/&gt;</SPAN>
&lt;/c:forEach&gt;
&lt;/p&gt;

&lt;/body&gt;
&lt;/html&gt;</PRE>
<P CLASS="western">L&aelig;g m&aelig;rke til, at vi her bruger af
<SPAN LANG="da-DK">&lt;c:out /&gt; for at skrive ud</SPAN>:</P>
<PRE CLASS="kode-western">Parameteren p&aring; en anden m&aring;de: <SPAN LANG="da-DK">&lt;c:out value=&quot;${param.navn}</SPAN>&quot;<SPAN LANG="da-DK">/&gt;</SPAN>&lt;br&gt;</PRE><P CLASS="western">
<SPAN LANG="da-DK">Ved at bruge &lt;c:out /&gt; </SPAN>bliver
specielle tegn som &lt;, &gt;, &amp;, ' og &quot; erstattet af deres
HTML-entiteter (d.v.s. &amp;lt;, &amp;gt;, &amp;amp;  o.s.v.). 
</P>
<P CLASS="western">Vi <I>kunne</I> godt bruge et EL-udtryk direkte i
HTML-koden, som vi plejer:</P>
<PRE CLASS="kode-western">Parameteren p&aring; en anden m&aring;de: <SPAN LANG="da-DK">${param.navn}</SPAN>&lt;br&gt;</PRE><P CLASS="western">
<SPAN LANG="da-DK">men da ville indholdet af navn-parameteren kunne
fortolkes som HTML-kode med de problemer, det medf&oslash;rer (se
<a href='kapitel8.jsp#afsn8.5.1'>afsnit 8.5.1</a>, HTML-injektion).</SPAN></P>
<P CLASS="western">Det er derfor en rigtig god id&eacute;, at udnytte
JSTLs indbyggede sikkerhedsfunktioner og altid  bruge &lt;c:out /&gt;,
hver gang man udskriver data, der kommer fra brugeren.</P>
<P CLASS="western">Hvis man &oslash;nsker at bruge &lt;c:out /&gt;
uden denne sikkerhedsfunktion (specielle tegn bliver erstattet med
deres HTML-entiteter) kan det sl&aring;s fra med attributten
<SPAN LANG="da-DK">escapeXml=&quot;false&quot;</SPAN>:</P>
<PRE CLASS="kode-western">Parameteren p&aring; en anden m&aring;de: <SPAN LANG="da-DK">&lt;c:out value=&quot;${param.navn}</SPAN>&quot; <SPAN LANG="da-DK"><B>escapeXml=&quot;false&quot;</B>/&gt;</SPAN>&lt;br&gt;</PRE>
<H3 CLASS="western">6.1.5 <a name='afsn6.1.5'></a>L&oslash;kker</H3>
<P CLASS="western">Her er eksemplet Syvtabellen fra <a href='kapitel2.jsp#afsn2.2.1'>afsnit 2.2.1</a>
skrevet i JSTL-syntaks:</P>
<PRE CLASS="kode-western">&lt;!-- &lt;%@ taglib uri=&quot;http://java.sun.com/jsp/jstl/core&quot; prefix=&quot;c&quot;%&gt; --&gt;
&lt;html&gt;
&lt;head&gt;&lt;title&gt;Syvtabellen med JSTL&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;
&lt;p&gt;Her er syv-tabellen:&lt;br&gt;

<B>&lt;c:forEach var=&quot;i&quot; <SPAN LANG="da-DK">begin</SPAN>=&quot;1&quot; end=&quot;10&quot;&gt;</B>
  Syv gange <B>${i}</B> er: <B>${7*i}</B>.&lt;br&gt;
<B>&lt;/c:forEach&gt;</B>

&lt;/p&gt;
&lt;/body&gt;
&lt;/html&gt;</PRE><P CLASS="western" ALIGN=CENTER>
<BR><IMG SRC="bog7_html_m6166f94.png" NAME="Grafik81" ALIGN=BOTTOM BORDER=0></P>

<P CLASS="western">Man kan ogs&aring; genneml&oslash;be andet end
tal. I <a href='kapitel6.jsp#afsn6.1.4'>afsnit 6.1.4</a> findes et eksempel hvor alle parametrene
genneml&oslash;bes.</P>
<P CLASS="western" STYLE="">Herunder l&oslash;ber
vi gennem nogle strenge med navne p&aring; frugter:</P>
<PRE CLASS="kode-western">&lt;!-- &lt;%@ taglib uri=&quot;http://java.sun.com/jsp/jstl/core&quot; prefix=&quot;c&quot;%&gt; --&gt;
&lt;html&gt;
&lt;head&gt;&lt;title&gt;L&oslash;kker med JSTL&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;
&lt;p&gt;Her er nogle frugter:&lt;br&gt;

  &lt;c:forEach var=&quot;f&quot; <B>items=&quot;&aelig;ble,p&aelig;re,banan,blomme&quot;</B>&gt;
    En frugt: ${f}&lt;br&gt;
  &lt;/<IMG SRC="bog7_html_m715b77f0.png" NAME="Grafik18" ALIGN=RIGHT BORDER=0>c:forEach&gt;

&lt;/p&gt;
&lt;/body&gt;
&lt;/html&gt;</PRE>





<H3 CLASS="western">6.1.6 <a name='afsn6.1.6'></a>Oversigt</H3>
<P CLASS="western">Her er en oversigt over alle koderne i dette
core-tagbiblioteket.</P>
<TABLE BORDER=0 CELLPADDING=3 CELLSPACING=0>
  <COL*>
  <COL*>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;c:set</P>
    </TD>
    <TD>
      <P CLASS="western">S&aelig;tter/opretter en variabel til et
      udtryk. Virkefelt kan angives med scope=... der kan v&aelig;re
      page, request, session eller application.</P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;c:remove</P>
    </TD>
    <TD>
      <P CLASS="western">Fjerner en variabel (fra et bestemt virkefelt
      hvis scope=... er angivet).</P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;c:out</P>
    </TD>
    <TD>
      <P CLASS="western">Udskriver et udtryk/en variabel. Det svarer
      alts&aring; til &lt;%= ... &gt;, blot erstattes alle specielle
      tegn med HTML-entiteter (kan sl&aring;s fra med escapeXml=&quot;false&quot;)</P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;c:import url=...</P>
    </TD>
    <TD>
      <P CLASS="western">Henter indholdet af en absolut eller relativ
      URL og putter ind i siden eller i en variabel hvis var=... og
      scope=... er angivet. 
      </P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;c:param name=...</P>
      <P CLASS="western">(inde i &lt;c:import&gt;)</P>
    </TD>
    <TD>
      <P CLASS="western">Tilf&oslash;jer parameter til en
      &lt;c:import&gt;-foresp&oslash;rgsel.</P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;c:redirect url=...</P>
    </TD>
    <TD>
      <P CLASS="western">Omdirigerer til en anden URL.</P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;c:url</P>
    </TD>
    <TD>
      <P CLASS="western">Definerer en URL. 
      </P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;c:if test=...</P>
    </TD>
    <TD>
      <P CLASS="western">Betingelse. Kroppen udf&oslash;res, hvis
      betingelsen er opfyldt.</P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;c:choose</P>
    </TD>
    <TD>
      <P CLASS="western">V&aelig;lger mellem et antal alternativer,
      m&aelig;rket med &lt;when&gt; og &lt;otherwise&gt; 
      </P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">  &lt;c:when test=...</P>
      <P CLASS="western">(inde i &lt;c:choose&gt;)</P>
    </TD>
    <TD>
      <P CLASS="western">Kroppen udf&oslash;res, hvis betingelsen er
      opfyldt.</P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">  &lt;c:otherwise</P>
      <P CLASS="western">(inde i &lt;c:choose&gt;)</P>
    </TD>
    <TD>
      <P CLASS="western">Kroppen udf&oslash;res, hvis ingen af
      betingelserne i &lt;c:when var opfyldt.</P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;c:forEach</P>
    </TD>
    <TD>
      <P CLASS="western">Genneml&oslash;ber noget.</P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;c:forTokens items=... delims=...</P>
    </TD>
    <TD>
      <P CLASS="western">Opdeler en streng (items=) i bidder efter nogle
      skilletegn (delims=) og genneml&oslash;ber bidderne.</P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;c:catch</P>
    </TD>
    <TD>
      <P CLASS="western">Fanger alle undtagelser, der sker mellem
      &lt;c:catch&gt; og &lt;/c:catch&gt;.<BR>Med &lt;c:catch var=...&gt;
      kan undtagelsen gemmes i en variabel.</P>
    </TD>
  </TR>
</TABLE>
<H2 CLASS="western">6.2 <a name='afsn6.2'></a>Internationalisering og formatering (&lt;fmt:
&gt;)</SPAN></H2>
<P CLASS="western">JSTL har en lang r&aelig;kke funktioner til at
parse og formatere tal og datoer. De ligger i taglib-bet fmt, som
importeres med:</P>
<PRE CLASS="kode-western">&lt;%@ taglib uri=&quot;http://java.sun.com/jsp/jstl/fmt&quot; prefix=&quot;fmt&quot;%&gt;</PRE>
<H3 CLASS="western">6.2.1 <a name='afsn6.2.1'></a>Oversigt</H3>
<P CLASS="western">Her er en oversigt over alle koderne i dette
tagbibliotek.</P>
<TABLE BORDER=0 CELLPADDING=3 CELLSPACING=0>
  <COL*>
  <COL*>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;fmt:requestEncoding value=...</P>
    </TD>
    <TD>
      <P CLASS="western">S&aelig;tter tegns&aelig;tter for anmodningen.</P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;fmt:setLocale value=...</P>
    </TD>
    <TD>
      <P CLASS="western">S&aelig;tter sproget s&aring;dan, at
      formateringer sker efter dette sprog (f.eks.: value=&quot;da_DK&quot;)</P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;fmt:timeZone value=...</P>
    </TD>
    <TD>
      <P CLASS="western">S&aelig;tter tidszonen for alle operationen i
      kroppen</P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;fmt:setTimeZone value=...</P>
    </TD>
    <TD>
      <P CLASS="western">S&aelig;tter tidszonen globalt</P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;fmt:bundle basename=... 
      </P>
    </TD>
    <TD>
      <P CLASS="western">Indl&aelig;ser et resursebundt, der kan bruges
      i kroppen.</P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;fmt:setBundle basename=... 
      </P>
    </TD>
    <TD>
      <P CLASS="western">Indl&aelig;ser et resursebundt globalt. 
      </P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;fmt:message key=...</P>
    </TD>
    <TD>
      <P CLASS="western">Sl&aring;r op i resursebundt og formaterer og
      udskriver resultatet</P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">  &lt;fmt:param&gt;</P>
      <P CLASS="western">(inde i &lt;fmt:message&gt;)</P>
    </TD>
    <TD>
      <P CLASS="western">Supplerer et opslag med &lt;fmt:message&gt; med
      et argument</P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;fmt:formatNumber</P>
    </TD>
    <TD>
      <P CLASS="western">Formaterer et tal</P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;fmt:parseNumber</P>
    </TD>
    <TD>
      <P CLASS="western">Fortolker en streng som et tal</P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;fmt:formatDate value=...</P>
    </TD>
    <TD>
      <P CLASS="western">Formaterer en dato/tid</P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;fmt:parseDate</P>
    </TD>
    <TD>
      <P CLASS="western">Fortolker en streng som en dato/tid</P>
    </TD>
  </TR>
</TABLE>


<H3 CLASS="western" STYLE="">6.2.2 <a name='afsn6.2.2'></a>Eksempel
p&aring; brug</H3>
<P CLASS="western">Her er et eksempel p&aring;, hvordan man arbejder
med datoer:</P>
<PRE CLASS="kode-western">&lt;!-- &lt;%@ taglib uri=&quot;http://java.sun.com/jsp/jstl/core&quot; prefix=&quot;c&quot;%&gt; 
     &lt;%@ taglib uri=&quot;http://java.sun.com/jsp/jstl/fmt&quot; prefix=&quot;fmt&quot;%&gt; --&gt;
&lt;html&gt;
&lt;head&gt;&lt;title&gt;Dato med JSTL&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;
&lt;p&gt;
  Det er lige nu: 
  &lt;jsp:useBean id=&quot;tid&quot; class=&quot;java.util.Date&quot; /&gt;
  &lt;c:set var=&quot;t&quot; value=&quot;${<SPAN LANG="da-DK">tid.hours</SPAN>}&quot; /&gt;
  &lt;c:choose&gt;
    &lt;c:when test=&quot;${t &lt;= 9}&quot;&gt;morgen&lt;/c:when&gt;
    &lt;c:when test=&quot;${t &lt;= 12}&quot;&gt;formiddag&lt;/c:when&gt;
    &lt;c:when test=&quot;${t &lt;= 17}&quot;&gt;eftermiddag&lt;/c:when&gt;
    &lt;c:when test=&quot;${t &lt;= 21}&quot;&gt;aften&lt;/c:when&gt;
    &lt;c:otherwise&gt;nat&lt;/c:otherwise&gt;
  &lt;/c:choose&gt;
&lt;/p&gt;

&lt;p&gt;
  Datoen formateret: &lt;fmt:<SPAN LANG="da-DK">formatDate</SPAN> value=&quot;${tid}&quot; /&gt;&lt;br&gt;
  Datoen uformateret: ${tid}&lt;br&gt;
&lt;/p&gt;
&lt;/body&gt;
&lt;/html&gt;</PRE><P CLASS="western">
Sammenlign med eksemplet i <a href='kapitel2.jsp#afsn2.3'>afsnit 2.3</a>.</P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog7_html_cbe16c4.png" NAME="Grafik80" ALIGN=BOTTOM BORDER=0></P>
<P CLASS="western">F&oslash;rst <SPAN LANG="da-DK">opretter vi et
Date-objekt og knytter det til variablen 'tid':</SPAN></P>
<PRE CLASS="kode-western">  &lt;jsp:useBean id=&quot;tid&quot; class=&quot;java.util.Date&quot; /&gt;</PRE><P CLASS="western">
<SPAN LANG="da-DK">I almindelig JSP ville man skrive 'new Date()'.
Den specielle m&aring;de med &lt;jsp:useBean /&gt; diskuteres i
<a href='kapitel6.jsp#afsn6.8'>afsnit 6.8</a>, Kommunikation mellem JSTL og Java)</SPAN>:</P>
<P CLASS="western">S&aring; afl&aelig;ser vi, hvad klokken er med
${<SPAN LANG="da-DK">tid.hours</SPAN>} (svarer til 'tid.getHours()' i
almindelig JSP) og s&aelig;tter resultatet ind i variablen 't':</P>
<PRE CLASS="kode-western">  &lt;c:set var=&quot;t&quot; value=&quot;${<SPAN LANG="da-DK">tid.hours</SPAN>}&quot; /&gt;</PRE><P CLASS="western">
Derefter v&aelig;lges mellem et s&aelig;t alternativer (svarer til en
switch-s&aelig;tning eller en r&aelig;kke k&aelig;dede if-s&aelig;tninger
i almindelig JSP):</P>
<PRE CLASS="kode-western">  &lt;c:choose&gt;
    &lt;c:when test=&quot;${t &lt;= 9}&quot;&gt;morgen&lt;/c:when&gt;</PRE><P CLASS="western">
Til sidst udskriver vi tiden formateret med</P>
<PRE CLASS="kode-western">&lt;fmt:<SPAN LANG="da-DK">formatDate</SPAN> value=&quot;${tid}&quot; /&gt;</PRE><H2 CLASS="western">
6.3 <a name='afsn6.3'></a>JSTL og databaser (&lt;sql: &gt;)</SPAN></H2>
<P CLASS="western"><SPAN LANG="da-DK">JSTL har nogle meget effektive
kommandoer til databasekommunikation</SPAN>. De importeres med:</P>
<PRE CLASS="kode-western">&lt;%@ taglib uri=&quot;http://java.sun.com/jsp/jstl/sql&quot; prefix=&quot;sql&quot;%&gt;</PRE><P CLASS="western">
For at f&aring; adgang til en database fra JSTL, kan databasedriveren
og -URL<SPAN LANG="da-DK">en </SPAN>angives i siden sammen med
JSP-koden:</P>
<PRE CLASS="kode-western">&lt;sql:setDataSource url=&quot;jdbc:mysql:///test&quot; driver=&quot;com.mysql.jdbc.Driver&quot; /&gt;</PRE><P CLASS="western">
Det er dog langt bedre, at angive det i web.xml under
intialiseringsparameteren med navn 
'javax.servlet.jsp.jstl.sql.dataSource':</P>
<PRE CLASS="kode-western">  &lt;context-param&gt;
<SPAN LANG="da-DK">    &lt;param-name&gt;javax.servlet.jsp.jstl.sql.dataSource&lt;/param-name&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;param-value&gt;jdbc:mysql:///test,com.mysql.jdbc.Driver&lt;/param-value&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;/context-param&gt;</SPAN></PRE><P CLASS="western">
Herunder har vi angivet &quot;jdbc:mysql:///test&quot; og
&quot;com.mysql.jdbc.Driver&quot;. Hvis man ville angive brugernavn
og adgangskode, f.eks. 'j' og 'hemli' skulle parameteren have v&aelig;ret:</P>
<PRE CLASS="kode-western">    &lt;param-value&gt;jdbc:mysql:///test,com.mysql.jdbc.Driver,j,hemli&lt;/param-value&gt;      </PRE>
<P CLASS="western">Her ses et eksempel p&aring; brug:</P>
<PRE CLASS="kode-western"><I>&lt;%-- Anvend JSTLs core- og database-tagbibliotek --%&gt;</I>
<SPAN LANG="da-DK">&lt;%@ taglib uri=&quot;http://java.sun.com/jsp/jstl/core&quot; prefix=&quot;c&quot;%&gt;</SPAN>
<SPAN LANG="da-DK">&lt;%@ taglib uri=&quot;http://java.sun.com/jsp/jstl/sql&quot; prefix=&quot;sql&quot;%&gt;</SPAN>

<SPAN LANG="da-DK">&lt;html&gt;</SPAN>
<SPAN LANG="da-DK">&lt;head&gt;&lt;title&gt;Databasearbejde med JSTL&lt;/title&gt;&lt;/head&gt;</SPAN>
<SPAN LANG="da-DK">&lt;body&gt;</SPAN>

<I>&lt;%-- datakilde angives i web.xml, men kan ogs&aring; direkte p&aring; siden (kun til test):</I>
<I>&lt;sql:setDataSource url=&quot;jdbc:mysql:///test&quot; driver=&quot;com.mysql.jdbc.Driver&quot; /&gt; --%&gt;</I>

<SPAN LANG="da-DK"><I>&lt;%-- lav en foresp&oslash;rgsel --%&gt;</I></SPAN>
<SPAN LANG="da-DK">&lt;sql:query var=&quot;kunder&quot; sql=&quot;SELECT * FROM kunder&quot; /&gt;</SPAN>

<SPAN LANG="da-DK">&lt;table border=&quot;1&quot; cellpadding=&quot;2&quot; cellspacing=&quot;0&quot;&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;tr&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;th&gt;Navn&lt;/th&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;th&gt;Kredit&lt;/th&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;/tr&gt;</SPAN>

<SPAN LANG="da-DK"><I>  &lt;%-- G&aring; gennem alle kunderne --%&gt;</I></SPAN>
<SPAN LANG="da-DK">  </SPAN>&lt;c:forEach var=&quot;kunde&quot; begin=&quot;0&quot; items=&quot;${kunder.rows}&quot;&gt;<IMG SRC="bog7_html_4ea3188.png" NAME="Grafik30" ALIGN=RIGHT BORDER=0>
<SPAN LANG="da-DK">    &lt;tr&gt;</SPAN>
<SPAN LANG="da-DK">      &lt;td&gt;${kunde.navn}&lt;/td&gt;</SPAN>
<SPAN LANG="da-DK">      &lt;td&gt;${kunde.kredit}&lt;/td&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;/tr&gt;</SPAN>
<SPAN LANG="da-DK">  </SPAN>&lt;/c:forEach&gt;
<SPAN LANG="da-DK">&lt;/table&gt;</SPAN>

<SPAN LANG="da-DK">&lt;/body&gt;</SPAN>
<SPAN LANG="da-DK">&lt;/html&gt;</SPAN></PRE>


<H3 CLASS="western">6.3.1 <a name='afsn6.3.1'></a>Oversigt</H3>
<P CLASS="western">Her er en oversigt over alle koderne i
sql-tagbiblioteket.</P>
<TABLE BORDER=0 CELLPADDING=3 CELLSPACING=0>
  <COL*>
  <COL*>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;sql:transaction</P>
    </TD>
    <TD>
      <P CLASS="western">Udf&oslash;rer alt kode i kroppen som &eacute;n
      databasetransaktion</P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;sql:query</P>
    </TD>
    <TD>
      <P CLASS="western">Udf&oslash;rer SQL-foresp&oslash;rgslen i
      kroppen eller i attributten sql=... 
      </P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;sql:update</P>
    </TD>
    <TD>
      <P CLASS="western">Udf&oslash;rer SQL-s&aelig;tningen i kroppen
      eller i attributten sql=... 
      </P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;sql:param</P>
    </TD>
    <TD>
      <P CLASS="western">S&aelig;tter en parameter i en SQL-s&aelig;tning.
            </P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;sql:dateParam</P>
    </TD>
    <TD>
      <P CLASS="western">S&aelig;tter en parameter i en SQL-s&aelig;tning
      (for Date-objekter). 
      </P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;sql:setDataSource</P>
    </TD>
    <TD>
      <P CLASS="western">S&aelig;tter database-URLen (kun til udvikling,
      ikke egnet til drift)</P>
    </TD>
  </TR>
</TABLE>


<H2 CLASS="western">6.4 <a name='afsn6.4'></a>XML-behandling  (&lt;x: &gt;)</SPAN></H2>
<P CLASS="western">JSTL har fin underst&oslash;ttelse for behandling
af XML-data. De har pr&aelig;fikset 'x' og importeres med:</P>
<PRE CLASS="kode-western">&lt;%@ taglib uri=&quot;http://java.sun.com/jsp/jstl/xml&quot; prefix=&quot;x&quot;%&gt;</PRE>
<H3 CLASS="western">6.4.1 <a name='afsn6.4.1'></a>Syndikering med XML-funktionerne i JSTL</H3>
<P CLASS="western"><SPAN LANG="da-DK">Dette afsnit foruds&aelig;tter,
at du har l&aelig;st <a href='kapitel11.jsp#afsn11.3'>afsnit 11.3</a>,  Syndikering (nyhedsf&oslash;dning).</SPAN></P>
<P CLASS="western"><SPAN LANG="da-DK">Indholdssyndikering (f&oslash;dning
af nyheder fra andre websider ind i ens egne) er beskrevet i <a href='kapitel11.jsp#afsn11.3'>afsnit
11.3</a>. Man kan udnytte JSTLs XML-funktioner til at flette andres
RSS-filer med nyheder ind i ens egne sider. </SPAN>
</P>
<P CLASS="western"><SPAN LANG="da-DK">Herunder et eksempel, hvor vi
fletter vi nyheder fra Danmarks Radio ind</SPAN>.</P>
<P CLASS="western"><SPAN LANG="da-DK">F&oslash;rst importeres core-
og XML-taglibbet. Derefter hentes en ekstern webside med nyhederne
med &lt;c:import</SPAN>&gt;, der efter parses som XML med <SPAN LANG="da-DK">&lt;x:parse&gt;
og l&aelig;gges i variablen rss.</SPAN></P>
<P CLASS="western"><SPAN LANG="da-DK">Denne variabel bruges derefter
til, at navige</SPAN>re rundt i DOM-tr&aelig;et og med passende
XPath-udtryk genneml&oslash;be elementer med &lt;x:forEach&gt; og
udskrive elementer med &lt;x:out&gt;.</P>

<PRE CLASS="kode-western">&lt;%@ taglib uri=&quot;http://java.sun.com/jsp/jstl/core&quot; prefix=&quot;c&quot;%&gt;
<SPAN LANG="da-DK">&lt;%@ taglib uri=&quot;http://java.sun.com/jsp/jstl/xml&quot; prefix=&quot;x&quot;%&gt;</SPAN>
<SPAN LANG="da-DK">&lt;html&gt;</SPAN>
<SPAN LANG="da-DK">&lt;head&gt;&lt;title&gt;Syndikering med JSTL og XML&lt;/title&gt;&lt;/head&gt;</SPAN>
<SPAN LANG="da-DK">&lt;body&gt;</SPAN>

<SPAN LANG="da-DK">&lt;c:import var=&quot;rssKilde&quot; url=&quot;<B>http://www.dr.dk/nyheder/html/nyheder/rss/</B>&quot;/&gt;</SPAN>
<SPAN LANG="da-DK">&lt;x:parse var=&quot;rss&quot; doc=&quot;${rssKilde}&quot;/&gt;</SPAN>

<SPAN LANG="da-DK">&lt;h1&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;x:out <B>select=&quot;$rss//*[name()='channel']/*[name()='title'][1]&quot;</B>/&gt;</SPAN>
<SPAN LANG="da-DK">&lt;/h1&gt;</SPAN>
<SPAN LANG="da-DK">&lt;x:out <B>select=&quot;$rss//*[name()='channel']/*[name()='description'][1]&quot;</B>/&gt;</SPAN>
<SPAN LANG="da-DK">&lt;br&gt;</SPAN>
<SPAN LANG="da-DK">L&aelig;s flere nyheder </SPAN>
<SPAN LANG="da-DK">&lt;a href=&quot;&lt;x:out select=&quot;$rss//*[name()='channel']/*[name()='link'][1]&quot;/&gt;&quot;&gt;her&lt;/a&gt;</SPAN>

<SPAN LANG="da-DK">&lt;ul&gt;</SPAN>
<SPAN LANG="da-DK"><B>  &lt;x:forEach select=&quot;$rss//*[name()='item']&quot;&gt;</B></SPAN>
<SPAN LANG="da-DK">    &lt;li&gt;</SPAN>
<SPAN LANG="da-DK">      <B>&lt;x:out select=&quot;./*[name()='title']&quot;/&gt;</B>&lt;br&gt;</SPAN>
<SPAN LANG="da-DK">      &lt;font size=&quot;-1&quot;&gt;</SPAN>
<SPAN LANG="da-DK">        &lt;x:out select=&quot;./*[name()='description']&quot; escapeXml=&quot;false&quot; /&gt;</SPAN>
<SPAN LANG="da-DK">        &lt;a href=&quot;&lt;x:out select=&quot;./*[name()='link']&quot;/&gt;&quot;&gt;l&aelig;s mere&lt;/a&gt;&lt;br&gt;&lt;br&gt;</SPAN>
<SPAN LANG="da-DK">    <IMG SRC="bog7_html_m52b0733d.png" NAME="Grafik58" ALIGN=RIGHT BORDER=0>  &lt;/font&gt;</SPAN>
<SPAN LANG="da-DK">    &lt;/li&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;/x:forEach&gt;</SPAN>
<SPAN LANG="da-DK">&lt;/ul&gt;</SPAN>

<SPAN LANG="da-DK">&lt;/body&gt;</SPAN>
<SPAN LANG="da-DK">&lt;/html&gt;</SPAN></PRE>

<H3 CLASS="western" STYLE="">6.4.2 <a name='afsn6.4.2'></a>Caching
af nyhedskilder</H3>
<P CLASS="western">Kommandoerne</P>
<PRE CLASS="kode-western">&lt;c:import var=&quot;rssKilde&quot; url=&quot;http://www.dr.dk/nyheder/html/nyheder/rss/&quot;/&gt;
&lt;x:parse var=&quot;rss&quot; doc=&quot;${rssKilde}&quot;/&gt;</PRE><P CLASS="western">
henter nyhederne fra DR og fortolker XML-koden, hver gang der sp&oslash;rges
p&aring; siden. 
</P>
<P CLASS="western">Ved mange foresp&oslash;<SPAN LANG="da-DK">rgsler
kan dette f&oslash;re til lange svartider og un&oslash;dig stor
belastning af nyhedskilden. Det kunne derfor v&aelig;re en id&eacute;,
at cache det fortolkede XML-dokument i f.eks. en time</SPAN>. 
</P>
<P CLASS="western">I JSTL kan det g&oslash;res ved at gemme det
<SPAN LANG="da-DK">fortolkede </SPAN>dokument i application-objektet
sammen med en tidsstempel. Ved en anmodning, kontrolleres det, om der
er g&aring;et mere end en time (3600000 millisekunder) og  kun da
hentes XML-dokumentet fra serveren:</P>
<PRE CLASS="kode-western">&lt;jsp:useBean id=&quot;nu&quot; class=&quot;java.util.Date&quot;/&gt;
<SPAN LANG="da-DK">&lt;c:if test=&quot;${nu.time &gt; cachetid-3600000}&quot;&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;c:import var=&quot;rssKilde&quot; url=&quot;<B>http://www.dr.dk/nyheder/html/nyheder/rss/</B>&quot;/&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;x:parse var=&quot;rss&quot; doc=&quot;${rssKilde}&quot; <B>scope=&quot;application&quot;</B>/&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;c:set var=&quot;cachetid&quot; value=&quot;${nu.time}&quot; <B>scope=&quot;application&quot;</B>/&gt;</SPAN>
<SPAN LANG="da-DK">&lt;/c:if&gt;</SPAN></PRE>
<H3 CLASS="western">6.4.3 <a name='afsn6.4.3'></a>WebRowSet og XML-transformering med JSTL</H3>
<P CLASS="western">Lad os nu se p&aring;, hvordan man kunne
transformere et XML-dokument om til HTML. 
</P>
<P CLASS="western"><SPAN LANG="da-DK">I <a href='kapitel5.jsp#afsn5.9.4'>afsnit 5.9.4</a> s&aring; vi,
hvordan et WebRowSet-objekt kunne repr&aelig;senterer et s&aelig;t
r&aelig;kker fra en database som XML. </SPAN>I det f&oslash;lgende
eksempel indl&aelig;ses og behandles dette XML-dokument, for at
producere en HTML-side med kunderne<SPAN LANG="da-DK">:</SPAN></P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog7_html_m7bca7471.png" NAME="Grafik82" ALIGN=BOTTOM BORDER=0></P>
<P CLASS="western"><SPAN LANG="da-DK">Her hentes f&oslash;rst data i
et WebRowSet, der skrives ned i variablen kundeXml, der er oprettet
med &lt;jsp:useBean&gt;, s&aring; den b&aring;de er tilg&aelig;ngelig
for almindelig Javakode og for JSTL (j.v.f. <a href='kapitel6.jsp#afsn6.8'>afsnit 6.8</a>, Kommunikation mellem JSTL og Java).
Derefter parses den med &lt;x:parse&gt; og genneml&oslash;bes og alle
r&aelig;kkerne udskrives.</SPAN></P>
<PRE CLASS="kode-western">&lt;%@ page language=&quot;java&quot; import=&quot;java.sql.*, javax.sql.*, com.sun.rowset.*&quot; %&gt;
<SPAN LANG="da-DK"><I>&lt;%-- Bem&aelig;rk: rowset.jar fra Sun skal v&aelig;re i CLASSPATH --%&gt;</I></SPAN>

<SPAN LANG="da-DK"><I>&lt;%-- Anvend JSTLs core- og XML-tagbibliotek --%&gt;</I></SPAN>
<SPAN LANG="da-DK">&lt;%@ taglib uri=&quot;http://java.sun.com/jsp/jstl/core&quot; prefix=&quot;c&quot;%&gt;</SPAN>
<SPAN LANG="da-DK">&lt;%@ taglib uri=&quot;http://java.sun.com/jsp/jstl/xml&quot; prefix=&quot;x&quot;%&gt;</SPAN>

<SPAN LANG="da-DK">&lt;html&gt;</SPAN>
<SPAN LANG="da-DK">&lt;head&gt;&lt;title&gt;XML-transformering af WebRowSet med JSTL&lt;/title&gt;&lt;/head&gt;</SPAN>
<SPAN LANG="da-DK">&lt;body&gt;</SPAN>
<SPAN LANG="da-DK">&lt;%</SPAN>
  Class.forName(&quot;com.mysql.jdbc.Driver&quot;);
  Connection con = DriverManager.getConnec<SPAN LANG="da-DK">tion(&quot;jdbc:mysql:///test&quot;);</SPAN>
<SPAN LANG="da-DK">  Statement stmt = con.createStatement();</SPAN>
<SPAN LANG="da-DK">  ResultSet rs = stmt.executeQuery(&quot;SELECT * FROM kunder&quot;);</SPAN>

<SPAN LANG="da-DK">  <I>// Oprettelse fejler nogen gange f&oslash;rste gang (uvist hvorfor)</I></SPAN>
<SPAN LANG="da-DK">  try { new WebRowSetImpl(); } catch (Exception e) { } <I>// ignor&eacute;r fejlen</I></SPAN>
<SPAN LANG="da-DK">  WebRowSetImpl wrs = new WebRowSetImpl();</SPAN>

<SPAN LANG="da-DK">  //anden mulig l&oslash;sning, se  </SPAN><A CLASS="western" HREF="http://forum.java.sun.com/thread.jspa?threadID=540624&amp;tstart=270"><SPAN LANG="da-DK">http://forum.java.sun.com/thread.jspa?threadID=540624&amp;tstart=270</SPAN></A><SPAN LANG="da-DK"> (xxx ikke afpr&oslash;vet)</SPAN>
<SPAN LANG="da-DK">  //java.util.Locale loc =  Locale.getDefault();</SPAN>
<SPAN LANG="da-DK">  //java.util.Locale.setDefault(Locale.US);</SPAN>
<SPAN LANG="da-DK">  //WebRowSetImpl wrs = new WebRowSetImpl();</SPAN>
<SPAN LANG="da-DK">  //java.util.Locale.setDefault(loc);</SPAN>

<SPAN LANG="da-DK">  wrs.populate(rs);</SPAN>
<SPAN LANG="da-DK">  rs.close();</SPAN>
<SPAN LANG="da-DK">  // wrs.writeXml(System.out); <I>// Skriv evt XML i webserverens logfil</I></SPAN>
<SPAN LANG="da-DK">%&gt;</SPAN>

<SPAN LANG="da-DK"><I>&lt;%-- Skriv XML-streng til variablen kundeXml --%&gt;</I></SPAN>
<SPAN LANG="da-DK">&lt;jsp:useBean id=&quot;kundeXml&quot; class=&quot;java.io.StringWriter&quot; /&gt;</SPAN>
<SPAN LANG="da-DK">&lt;% wrs.writeXml(kundeXml); %&gt;</SPAN>

<SPAN LANG="da-DK"><I>&lt;%-- Fortolk XML-streng og put det parsede DOM-tr&aelig; ind i kunder. </I></SPAN>
<SPAN LANG="da-DK"><I>     Vi f&aring;r data ud at kundeXml (der er af typen StringWriter) til en streng</I></SPAN>
<SPAN LANG="da-DK"><I>     ved at s&aelig;tte den sammen med streng &quot; &quot; (&eacute;t mellemrum): &quot;${kundeXml} &quot; --%&gt;</I></SPAN>
<SPAN LANG="da-DK">&lt;x:parse var=&quot;kunder&quot; doc=&quot;${kundeXml} &quot;/&gt;</SPAN>

<SPAN LANG="da-DK">&lt;h1&gt;Liste over kunder (XML-transformeret WebRowSet)&lt;/h1&gt;</SPAN>

<SPAN LANG="da-DK"><I>&lt;%-- L&oslash;b gennem alle r&aelig;kkerne i tabellen og udskriv 1. og 2. kolonne --%&gt;</I></SPAN>
<SPAN LANG="da-DK">&lt;x:forEach select=&quot;$kunder//*[name()='currentRow']&quot;&gt;</SPAN>
<SPAN LANG="da-DK">  Navn: &lt;x:out select=&quot;*[1]&quot;/&gt;&lt;br&gt;</SPAN>
<SPAN LANG="da-DK">  Kredit: &lt;x:out select=&quot;*[2]&quot;/&gt;&lt;br&gt;</SPAN>
<SPAN LANG="da-DK">  &lt;hr&gt;</SPAN>
<SPAN LANG="da-DK">&lt;/x:forEach&gt;</SPAN>

<SPAN LANG="da-DK">Her er hele XML-dokumentet:</SPAN>
<SPAN LANG="da-DK">&lt;pre&gt;</SPAN>
<SPAN LANG="da-DK">&lt;c:out value=&quot;${kundeXml}&quot; /&gt;</SPAN>
<SPAN LANG="da-DK">&lt;/pre&gt;</SPAN>

<SPAN LANG="da-DK">&lt;/body&gt;</SPAN>
<SPAN LANG="da-DK">&lt;/html&gt;</SPAN></PRE>


<H3 CLASS="western">6.4.4 <a name='afsn6.4.4'></a>Oversigt</H3>
<P CLASS="western">Her er en oversigt over alle koderne i
XML-tagbiblioteket:</P>
<TABLE BORDER=0 CELLPADDING=3 CELLSPACING=0>
  <COL*>
  <COL*>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;x:parse</P>
    </TD>
    <TD>
      <P CLASS="western">Parser et XML-dokument, der kommer i kroppen
      eller som attributten 'source'.</P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;x:set</P>
    </TD>
    <TD>
      <P CLASS="western">S&aelig;tter en variabel til resultatet af et
      XPath-udtryk 
      </P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;x:out</P>
    </TD>
    <TD>
      <P CLASS="western">Udskriver noget, ligesom &lt;%= ... &gt;, men
      evaluerer XPath-udtryk. 
      </P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;x:forEach</P>
    </TD>
    <TD>
      <P CLASS="western">Genneml&oslash;ber et XPath-udtryk. 
      </P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;x:if test=...</P>
    </TD>
    <TD>
      <P CLASS="western">Betingelse. Kroppen udf&oslash;res, hvis
      XPath-udtrykket evaluerer til 'true'</P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;x:choose</P>
    </TD>
    <TD>
      <P CLASS="western">V&aelig;lger mellem et antal alternativer,
      m&aelig;rket med &lt;when&gt; og &lt;otherwise&gt; 
      </P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">  &lt;x:when test=...<BR>(inde i &lt;x:choose&gt;)</P>
    </TD>
    <TD>
      <P CLASS="western">Kroppen udf&oslash;res, hvis betingelsen er
      opfyldt.</P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">  &lt;x:otherwise<BR>(i &lt;x:choose&gt;)</P>
    </TD>
    <TD>
      <P CLASS="western">Kroppen udf&oslash;res, hvis ingen af
      betingelserne i &lt;c:when&gt; var opfyldt.</P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">&lt;x:transform</P>
    </TD>
    <TD>
      <P CLASS="western">Transformerer et XML-dokument med et XSLT
      stylesheet 
      </P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">  &lt;x:param<BR>(i &lt;x:transform&gt;)</P>
    </TD>
    <TD>
      <P CLASS="western">Tilf&oslash;jer parameter til en
      &lt;x:transform&gt;-operation 
      </P>
    </TD>
  </TR>
</TABLE>


<H2 CLASS="western">6.5 <a name='afsn6.5'></a>Forskellige funktioner (&lt;fn: &gt;)</SPAN></H2>
<P CLASS="western">En r&aelig;kke forskellige funktioner til at
arbejde med strenge, kan importeres med:</P>
<PRE CLASS="kode-western">&lt;%@ taglib uri=&quot;http://java.sun.com/jsp/jstl/functions&quot; prefix=&quot;fn&quot; %&gt;</PRE><P CLASS="western">
Derefter kan man skrive fn:funktionsnavn(...) inde i et EL-udtryk,
for at kalde funktionen.</P>
<P CLASS="western">F.eks. kunne man i forrige eksempel skrive
kundenavnet med store bogstaver med:</P>
<PRE CLASS="kode-western">      &lt;td&gt;${<B>fn:toUpperCase(</B>kunde.navn<B>)</B>}&lt;/td&gt;</PRE><P CLASS="western">
Man kunne i <a href='kapitel6.jsp#afsn6.1.4'>afsnit 6.1.4</a> udskrive l&aelig;ngden af parameteren navn
med:</P>
<PRE CLASS="kode-western">L&aelig;ngden af parameteren navn: ${fn:length(param.navn)}</PRE><P CLASS="western">
eller m&aring;ske kontrollere l&aelig;ngden af det indtastede navn:</P>
<PRE CLASS="kode-western">&lt;c:if test=&quot;${<B>fn:length(</B>param.navn<B>)</B> &lt; 2}&quot; &gt;
  Du skal indtaste et navn p&aring; mindst to tegn
&lt;/c:if&gt;</PRE>

<H3 CLASS="western">6.5.1 <a name='afsn6.5.1'></a>Oversigt</H3>
<P CLASS="western">Her er en oversigt over funktionerne:</P>
<TABLE BORDER=0 CELLPADDING=3 CELLSPACING=0>
  <COL>
  <COL>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">length( objekt )</P>
    </TD>
    <TD>
      <P CLASS="western">Finder l&aelig;ngden af objektet. <BR>Er
      objektet en streng, giver det antallet af tegn.<BR>Er objektet et
      array eller en anden datastruktur (collection), giver det antallet
      af elementer. 
      </P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">contains( streng, delstreng
      )<BR>containsIgnoreCase( streng, delstreng )<BR>startsWith(
      streng, delstreng )<BR>endsWith( streng, delstreng )</P>
    </TD>
    <TD>
      <P CLASS="western">Unders&oslash;ger om en streng indeholder en
      delstreng. 
      </P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">escapeXml( streng )</P>
    </TD>
    <TD>
      <P CLASS="western">Erstatter specielle tegn med deres HTML-entitet
      s&aring;dan, at tegn i strengen ikke kan (mis)fortolkes som
      HTML-kode. 
      </P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">indexOf( streng, delstreng )</P>
    </TD>
    <TD>
      <P CLASS="western">Finder indekset (placeringen) i en streng af en
      delstreng. 
      </P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">join( streng[], mellemstreng )</P>
    </TD>
    <TD>
      <P CLASS="western">S&aelig;tter et array af strenge sammen til &eacute;n
      streng. 
      </P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">replace( streng, f&oslash;rstr, efterstr )</P>
    </TD>
    <TD>
      <P CLASS="western">Giver en streng, hvor alle forekomster af
      delstrengen f&oslash;rstr er erstattet med strengen efterstr. 
      </P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">split( streng, separatorstreng )</P>
    </TD>
    <TD>
      <P CLASS="western">Opdeler en streng i et array af delstrenge. 
      </P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">substring( streng, startpos, slutpos )</P>
    </TD>
    <TD>
      <P CLASS="western">Giver delstrengen fra startpos til og med
      slutpos. 
      </P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">substringBefore( streng, delstreng )</P>
      <P CLASS="western">substringAfter( streng, delstreng )</P>
    </TD>
    <TD>
      <P CLASS="western">Giver den del af strengen der er f&oslash;r
      (hhv. efter) delstrengen. 
      </P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">toUpperCase( streng )</P>
      <P CLASS="western">toLowerCase( streng )</P>
    </TD>
    <TD>
      <P CLASS="western">Giver en streng hvor alle tegn er lavet om til
      store (hhv. sm&aring;) bogstaver. 
      </P>
    </TD>
  </TR>
  <TR BGCOLOR="#ffffff">
    <TD>
      <P CLASS="western">trim( streng )</P>
    </TD>
    <TD>
      <P CLASS="western">Fjerner blanktegn fra begge ender af strengen. 
      </P>
    </TD>
  </TR>
</TABLE>


<H2 CLASS="western">6.6 <a name='afsn6.6'></a>Installation af JSTL og EL</SPAN></H2>
<P CLASS="western">For at webserveren kender taglibbet, skal
JAR-filerne jstl.jar og standard.jar v&aelig;re tilg&aelig;ngelig for
webapplikationen, f.eks. ved at de ligger i WEB-INF/lib/. 
</P>
<P CLASS="western">Du kan f.eks. kopiere dem fra
webapps/jsp-examples/WEB-INF/lib/ i JSP-eksemplerne, der fulgte med i
Tomcat. 
</P>
<P CLASS="western">Hvis du har problemer, s&aring; se i <a href='kapitel4.jsp#afsn4.9.6'>afsnit 4.9.6</a>,
hvordan du kan l&aelig;gge JAR-filerne ind.</P>


<H3 CLASS="western">6.6.1 <a name='afsn6.6.1'></a>Versionsproblemer med JSTL og EL</H3>
<P CLASS="western">JSTL og EL har udviklet sig lidt knudret: Fra at
v&aelig;re bygget sammen til at v&aelig;re adskilte ting, der kan
bruges uafh&aelig;ngigt af hinanden. Nu (med JSP 2.0) er EL bygget
direkte ind i webserveren, mens JSTL er en JAR-fil, der skal v&aelig;re
tilg&aelig;ngelig for webapplikationen. Derfor kan man komme ud for
en del b&oslash;vl med JSTL og EL i nogle kombinationer. 
</P>
<P CLASS="western">Man skal her v&aelig;re opm&aelig;rksom p&aring;,
at ens <SPAN LANG="da-DK">web.xml-fil kan v&aelig;re afg&oslash;rende
for, om tingene virker som forventet, idet web.xml i version 2.3 som
udgangspunkt <I>ikke</I> underst&oslash;tter EL, mens version 2.4
g&oslash;r. </SPAN>
</P>
<P CLASS="western"><SPAN LANG="da-DK">Har man en web.xml i version
2.3, </SPAN>kan det v&aelig;re at man er n&oslash;dt til at skrive
EL-udtryk ud med JSTL-koden &lt;c:out /&gt;:</P>
<PRE CLASS="kode-western">Det svarer til &lt;c:out value=&quot;${12*alder}&quot; /&gt; m&aring;neder.&lt;br&gt;</PRE>
<P CLASS="western">Det bedste er at opgradere sin web.xml-fil. Her
ses starten af en web.xml-fil i version 2.3 (der f&aring;r
webserveren til kun at fortolke EL-udtryk, der er inde i JSTL-koder):</P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>web.xml
i version 2.3</I></FONT></P>
<PRE CLASS="kode-western">&lt;?xml version = '1.0' encoding = 'ISO-8859-15'?&gt;
<SPAN LANG="da-DK">&lt;!DOCTYPE web-app PUBLIC &quot;-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN&quot; &quot;http://java.sun.com/dtd/web-app_2_3.dtd&quot;&gt;</SPAN>
<SPAN LANG="da-DK">&lt;web-app&gt;</SPAN></PRE>
<P CLASS="western">Disse linjer skal erstattes med det f&oslash;lgende
(web.xml i version 2.4 - du kan kopiere det fra den web.xml, der
f&oslash;lger med eksemplerne i Tomcat):</P>
<P ALIGN=CENTER STYLE="margin-top: 0.11cm; margin-bottom: 0.11cm"><FONT SIZE=2 STYLE="font-size: 9pt"><I>web.xml
i version 2.4</I></FONT></P>
<PRE CLASS="kode-western">&lt;?xml version=&quot;1.0&quot; encoding=&quot;ISO-8859-1&quot;?&gt;
&lt;web-app xmlns=&quot;http://java.sun.com/xml/ns/j2ee&quot;
    xmlns:xsi=&quot;http://www.w3.org/2001/XMLSchema-instance&quot;
    xsi:schemaLocation=&quot;http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd&quot;
    version=&quot;2.4&quot;&gt;</PRE>
<P CLASS="western">Endelig skal man v&aelig;re opm&aelig;rksom p&aring;,
at JSTL-taglib-bibliotekerne nu ligger under 'jsp':</P>
<PRE CLASS="kode-western"><I>&lt;%-- Anvend JSTL 1.1's core- og XML-tagbibliotek (JSP 2.0) --%&gt;</I>
<SPAN LANG="da-DK">&lt;%@ taglib uri=&quot;http://java.sun.com<B>/jsp/</B>jstl/core&quot; prefix=&quot;c&quot;%&gt;</SPAN>
<SPAN LANG="da-DK">&lt;%@ taglib uri=&quot;http://java.sun.com<B>/jsp/</B>jstl/xml&quot; prefix=&quot;x&quot;%&gt;</SPAN></PRE><P CLASS="western">
hvor man f&oslash;r i tiden skrev f.eks.:</P>
<PRE CLASS="kode-western"><I>&lt;%-- Anvend JSTL 1.0's core- og XML-tagbibliotek (JSP 1.1)  --%&gt;</I>
<SPAN LANG="da-DK">&lt;%@ taglib uri=&quot;http://java.sun.com/jstl/core&quot; prefix=&quot;c&quot;%&gt;</SPAN>
<SPAN LANG="da-DK">&lt;%@ taglib uri=&quot;http://java.sun.com/jstl/xml&quot; prefix=&quot;x&quot;%&gt;</SPAN></PRE>
<H2 CLASS="western" STYLE="">6.7 <a name='afsn6.7'></a>JSTL versus
almindelig javakode i JSP</SPAN></H2>
<P CLASS="western">N&aring;r nu man kan det samme med almindelig
javakode i JSP, hvorfor s&aring; l&aelig;re et nyt sprog og begynde
at programmere i JSTL i stedet?</P>
<UL>
  <LI><P CLASS="western">JSTL er simplere end Java. Man kan ikke n&aelig;r
  s&aring; mange ting i JSTL som i almindelig javakode og syntaksen er
  simplere.</P>
  <LI><P CLASS="western">For ikke-Java-kyndige har JSTL en betydelig
  lettere syntaks end hvis de skulle lave almindelig javakode i JSP.</P>
  <LI><P CLASS="western">JSTL er en anelse langsommere end almindelig
  javakode.</P>
  <LI><P CLASS="western">JSTL har mange funktioner til at hente data
  ud fra java-objekter og er velegnet til at lave en adskillelse af
  pr&aelig;sentation (HTML-kode) og forretningslogik (der i st&oslash;rre
  projekter nemmest skrives som <SPAN LANG="da-DK">selvst&aelig;ndige</SPAN>
  java-klasser uden for JSP-siderne).</P>
  <LI><P CLASS="western">Hvis man laver et st&oslash;rre projekt, der
  involverer at HTML-designere ogs&aring; skal redigere i
  dokumenterne, er JSTL velegnet, da JSTL overholder XML-syntaksen. De
  fleste HTML-editorer lader derfor JSTL-koderne v&aelig;re (og
  tillader endda at redigere i dem), mens almindelig javakode mellem
  &lt;% og %&gt; ofte g&aring;r tabt<A CLASS="sdfootnoteanc" NAME="sdfootnote2anc" HREF="#sdfootnote2sym"><SUP>2</SUP></A>.</P>
</UL>
<P CLASS="western"><SPAN LANG="da-DK">Det anbefales, at bruge JSTL
til <I>pr&aelig;sentation af informationer</I>. Det er n&aelig;ppe en
god id&eacute; at skrive indviklet forretningslogik i JSTL, der er
Java mere velegnet.</SPAN></P>

<H2 CLASS="western">6.8 <a name='afsn6.8'></a>Kommunikation mellem JSTL og Java</SPAN></H2>
<P CLASS="western">Bem&aelig;rk at JSTL og almindelig javakode i JSP
fungerer p&aring; forskellige m&aring;der og at det sj&aelig;ldent er
nogen god id&eacute;, at have begge slags kode i samme JSP-sider. 
</P>
<P CLASS="western">Man kan for eksempel ikke uden videre bruge en
variabel fra JSTL i Java eller omvendt.</P>
<P CLASS="western">S&aring;ledes vil JSP-koden</P>
<PRE CLASS="kode-western">  <SPAN LANG="da-DK">&lt;%</SPAN>
<SPAN LANG="da-DK">    Date tid = new Date();</SPAN>
<SPAN LANG="da-DK">  %&gt;</SPAN></PRE><P CLASS="western">
<SPAN LANG="da-DK">der opretter et Date-objekt og knytter det til
variablen 'tid', <I>ikke</I> g&oslash;re den </SPAN>tilg&aelig;ngelig
i JSTL. 
</P>
<P CLASS="western">Det skal man efterf&oslash;lgende g&oslash;re ved,
at gemme den som attribut til page, request, session eller
application-objektet. F&oslash;lgende vil s&aring;ledes fungere fint:</P>
<PRE CLASS="kode-western">  <SPAN LANG="da-DK">&lt;%</SPAN>
<SPAN LANG="da-DK">    Date tid = new Date();</SPAN>
    page.setAttribute(&quot;tid&quot;, tid );  <I>// lav variablen 'tid' i JSTL</I>
<SPAN LANG="da-DK">  %&gt;</SPAN>
<SPAN LANG="da-DK">  Klokken er ${tid}</SPAN></PRE>

<H3 CLASS="western">6.8.1 <a name='afsn6.8.1'></a>Javab&oslash;nner</H3>
<P CLASS="western">Man kan ogs&aring; bruge javab&oslash;nne-syntaksen
(javab&oslash;nner forklares i <a href='kapitel9.jsp'>kapitel 9</a>):</P>
<PRE CLASS="kode-western">  &lt;jsp:useBean id=&quot;tid&quot; class=&quot;java.util.Date&quot; /&gt;</PRE><P CLASS="western">
<SPAN LANG="da-DK">Man kan eventuelt give javab&oslash;nnen et
virkefelt, der giver mulighed for at genbruge det samme objekt n&aelig;ste
gang siden bes&oslash;ges (virkefelter er beskrevet senere, i <a href='kapitel9.jsp#afsn9.2.5'>afsnit
9.2.5</a>, Oversigt over de mulige virkefelter).</SPAN> 
</P>
<P CLASS="western">Her gives f.eks. sessionen som virkefelt:</P>
<PRE CLASS="kode-western">  &lt;jsp:useBean id=&quot;tid&quot; class=&quot;java.util.Date&quot; scope=&quot;session&quot; /&gt;</PRE><H3 CLASS="western">
6.8.2 <a name='afsn6.8.2'></a>Implicit definerede objekter i EL</H3>
<P CLASS="western">N&aring;r man skriver et udtryk i EL, kan man
v&aelig;lge pr&aelig;cist, hvad man vil have fat i, ved at benytte de
f&oslash;lgende implicitte variabler:</P>
<UL>
  <LI><P CLASS="western">pageScope, der giver adgang til attributter
  gemt i page-objektet</P>
  <LI><P CLASS="western">requestScope, der giver adgang til
  attributter gemt i request-objektet</P>
  <LI><P CLASS="western">sessionScope, der giver adgang til
  attributter gemt i session-objektet</P>
  <LI><P CLASS="western">applicationScope, der giver adgang til
  attributter gemt i application-objektet</P>
  <LI><P CLASS="western">pageContext, der s&oslash;ger alle
  ovenst&aring;ende objekter igennem for attributter</P>
  <LI><P CLASS="western">param, der giver adgang til parametre i
  request-objektet</P>
  <LI><P CLASS="western">paramValues, der giver adgang til
  parameterv&aelig;rdierne i request-objektet   </P>
  <LI><P CLASS="western">header, der giver adgang til HTTP-headere i
  anmodningen</P>
  <LI><P CLASS="western">headerValues, der giver adgang til v&aelig;rdierne
  af HTTP-headere i anmodningen   </P>
  <LI><P CLASS="western">cookie, der giver adgang til cookier, der
  fulgte med anmodningen</P>
  <LI><P CLASS="western">initParam, der giver initialieringsparametre
  for webapplikationen (i web.xml)</P>
</UL>
<P CLASS="western">Starter et EL-udtryk ikke med et af ovenst&aring;ende
ord, vil EL s&oslash;ge igennem alle implicitte variabler og derefter
s&oslash;ge page-, request-, session- og application-objektets
attributter igennem efter et objekt med det p&aring;g&aelig;ldende
navn.</P>

<H2 CLASS="western">6.9 <a name='afsn6.9'></a>Mere l&aelig;sning</SPAN></H2>
<UL>
  <LI><P CLASS="western"><SPAN LANG="da-DK">Du kan l&aelig;se mere om
  JSTL p&aring;:<BR> </SPAN><A CLASS="western" HREF="http://java.sun.com/products/jsp/jstl/"><SPAN LANG="da-DK">http://java.sun.com/products/jsp/jstl/</SPAN></A><SPAN LANG="da-DK">
  </SPAN>
  </P>
  <LI><P CLASS="western"><SPAN LANG="da-DK">Om JSTL i 'The J2EE
  Tutorial':<BR>
  </SPAN><A CLASS="western" HREF="http://java.sun.com/j2ee/1.4/docs/tutorial/doc/JSTL.html"><SPAN LANG="da-DK">http://java.sun.com/j2ee/1.4/docs/tutorial/doc/JSTL.html</SPAN></A><SPAN LANG="da-DK">
  </SPAN> 
  </P>
  <LI><P CLASS="western"><SPAN LANG="da-DK">Oversigten over alle
  JSTL-koderne kan ses p&aring;:<BR>
  </SPAN><A CLASS="western" HREF="http://java.sun.com/products/jsp/jstl/1.1/docs/tlddocs/"><SPAN LANG="da-DK">http://java.sun.com/products/jsp/jstl/1.1/docs/tlddocs/</SPAN></A></P>
</UL>


<DIV ID="sdfootnote1">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote1sym" HREF="#sdfootnote1anc">1</A>JSP
  med JSTL kan minde om sproget Coldfusion fra Macromedia/Allaire</P>
</DIV>
<DIV ID="sdfootnote2">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote2sym" HREF="#sdfootnote2anc">2</A>Desv&aelig;rre
  med &eacute;n undtagelse: Importeringen af et taglib foretages med
  koden &lt;%@ taglib ... %&gt;, der ikke overholder XML-syntaksen og
  ikke overlever i en HTML-designer. Det kan man dog omg&aring;, ved
  at l&aelig;gge den ind i en HTML-kommentar (&lt;!-- ... --&gt;),
  s&aring;dan her:<BR><B>&lt;!--</B> &lt;%@ taglib
  uri=&quot;http://java.sun.com/jsp/jstl/core&quot; prefix=&quot;c&quot;%&gt;
  <B>--&gt;</B> 
  </P>
</DIV>

<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel5.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel7.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_JSP.html'>om bogen</a>
<hr>
<font size=-2>http://javabog.dk/ - <b>Webprogrammering med Java Server Pages</b> af Jacob Nordfalk.
<br>
  Licens og kopiering under <a href='http://www.linuxbog.dk/licens.html'>&Aring;ben Dokumentlicens</a> (&Aring;DL)
  hvor intet andet er nvnt (72% af vrket).
</font>
<br>
nsker du at se de sidste 28% af dette vrk (275315 tegn)
skal du kbe bogen. S fr du pne figurer og layout, stikordsregister og en trykt bog med i kbet.
<!-- netlser: Wget/1.10, autoHent: true  -->
     

</body>
</html>
